﻿using StokYonetimSistemi.Business;
using StokYonetimSistemi.Entities;
using System;
using System.Windows.Forms;

namespace StokYonetimSistemi.WinFormsUI
{
    public partial class frmKategoriYonetimi : Form
    {
        private readonly KategoriManager _kategoriManager = new KategoriManager();

        public frmKategoriYonetimi()
        {
            // BU SATIR KALMALI. Tasarımcı dosyasındaki doğru metodu çağırır.
            InitializeComponent();
        }

        private void frmKategoriYonetimi_Load(object sender, EventArgs e)
        {
            KategorileriListele();
        }

        private void KategorileriListele()
        {
            try
            {
                dgvKategoriler.DataSource = _kategoriManager.TumKategorileriGetir();
                // Görünmesini istemediğimiz "Urunler" kolonunu gizleyelim.
                // Bu kolon, Entity'deki ilişkisel property'den dolayı otomatik gelir.
                if (dgvKategoriler.Columns["Urunler"] != null)
                {
                    dgvKategoriler.Columns["Urunler"].Visible = false;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Kategoriler listelenirken bir hata oluştu: " + ex.Message, "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnEkle_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrWhiteSpace(txtAd.Text))
            {
                MessageBox.Show("Kategori adı boş bırakılamaz!", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            try
            {
                var yeniKategori = new Kategori
                {
                    Ad = txtAd.Text,
                    Aciklama = txtAciklama.Text
                };
                _kategoriManager.KategoriEkle(yeniKategori);
                KategorileriListele(); // Listeyi yenile
                MessageBox.Show("Kategori başarıyla eklendi.", "Başarılı", MessageBoxButtons.OK, MessageBoxIcon.Information);
                Temizle();
            }
            catch (Exception ex)
            {
                MessageBox.Show("Ekleme sırasında hata oluştu: " + ex.Message, "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnGuncelle_Click(object sender, EventArgs e)
        {
            if (dgvKategoriler.CurrentRow == null)
            {
                MessageBox.Show("Lütfen güncellenecek bir kategori seçin.", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            if (string.IsNullOrWhiteSpace(txtAd.Text))
            {
                MessageBox.Show("Kategori adı boş bırakılamaz!", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            try
            {
                int seciliId = (int)dgvKategoriler.CurrentRow.Cells["Id"].Value;
                var guncellenecekKategori = new Kategori
                {
                    Id = seciliId,
                    Ad = txtAd.Text,
                    Aciklama = txtAciklama.Text
                };
                _kategoriManager.KategoriGuncelle(guncellenecekKategori);
                KategorileriListele();
                MessageBox.Show("Kategori başarıyla güncellendi.", "Başarılı", MessageBoxButtons.OK, MessageBoxIcon.Information);
                Temizle();
            }
            catch (Exception ex)
            {
                MessageBox.Show("Güncelleme sırasında hata oluştu: " + ex.Message, "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnSil_Click(object sender, EventArgs e)
        {
            if (dgvKategoriler.CurrentRow == null)
            {
                MessageBox.Show("Lütfen silinecek bir kategori seçin.", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            if (MessageBox.Show("Seçili kategoriyi silmek istediğinize emin misiniz?", "Silme Onayı", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
            {
                try
                {
                    int seciliId = (int)dgvKategoriler.CurrentRow.Cells["Id"].Value;
                    _kategoriManager.KategoriSil(seciliId);
                    KategorileriListele();
                    MessageBox.Show("Kategori başarıyla silindi.", "Başarılı", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    Temizle();
                }
                catch (Exception ex)
                {
                    MessageBox.Show("Silme sırasında hata oluştu: " + ex.Message, "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void dgvKategoriler_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            // Grid'de bir satıra tıklandığında bilgileri textbox'lara doldurur.
            if (e.RowIndex >= 0 && dgvKategoriler.CurrentRow != null)
            {
                txtAd.Text = dgvKategoriler.CurrentRow.Cells["Ad"].Value.ToString();
                txtAciklama.Text = dgvKategoriler.CurrentRow.Cells["Aciklama"].Value?.ToString();
            }
        }

        private void Temizle()
        {
            txtAd.Clear();
            txtAciklama.Clear();
            dgvKategoriler.ClearSelection();
        }
    }
}